###### Volume Acumulado 2012 a 2017 ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa funo tem como argumentos: direcao, produto e grupo. 
# direcao = (origem, destino)
# produto = (tora, acabado)
# grupo = (geral, grupo1, grupo2, grupo3)

# Pacotes usados
library(data.table)
library(dplyr)
library(tidyr)
library(ggplot2)
library(scales)
library(forcats) #para a funo fct_reorder()
library(gridExtra)
library(grid)

#  L sisdof_tora
sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                     colClasses = c("character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_tora$V1 <- NULL

# L sisdof_produto
sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                        colClasses = c("character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_produto$V1 <- NULL


#### Funcao para gerar graficos ####

vol_acumulado <- function (direcao, grupo) {
    # direcao = (origem, destino). Origem, implica tora. Destino, implica produto acabado.
    # grupo = (geral, grupo1, grupo2, grupo3)
    
    # geral = todas as espcies 
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    # Funo para passar apenas a primeira letra de uma palavra para maiscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Ttulos do grfico
    titulo.grupo <- capFirst(grupo)
    #g.sub.titulo <- "Produo madeireira acumulada de 2012 a 2017 (x 1.000 m^3)"
    
    # Dimensoes do Grafico
    #largura <- 10.3
    texto <- 21.87
    bola <- 25.5
    
    if (direcao == "origem") {
        
        # Muda diretrio de trabalho para o de Toras. Cria o diretorio se ja nao existir.
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.1.Toras", 
                                     "1.1.2.Volume.Acumulado")),
               dir.create(file.path("Figuras", 
                                    "1.1.Toras", 
                                    "1.1.2.Volume.Acumulado"),
                          recursive = TRUE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.1.Toras", 
                        "1.1.2.Volume.Acumulado"))
        
        
        # sisdof =  sisdof_tora. Origem, implica tora
        sisdof <- sisdof_tora
        
        # Legendas dos grficos a serem gerados
        g.titulo <- "Toras e toretes"  # Titulo do grafico
        
        # Cores do Grafico: Tons azuis 
        cor_segmento <- "dodgerblue3"                # cor da linha   
        cor_ponto <- "navy"                   # cor do ponto
        
    } else if (direcao == "destino") {
        
        ifelse(!dir.exists(file.path("Figuras", 
                                     "1.2.Produto.Acabado", 
                                     "1.2.2.Volume.Acumulado")),
               dir.create(file.path("Figuras", 
                                    "1.2.Produto.Acabado", 
                                    "1.2.2.Volume.Acumulado"),
                          recursive = TRUE),
               FALSE)
        
        setwd(file.path("Figuras", 
                        "1.2.Produto.Acabado", 
                        "1.2.2.Volume.Acumulado"))
        
        # sisdof = sisdof_produto. Destino, implica produto acabado.
        sisdof <- sisdof_produto
        
        # Legendas dos grficos a serem gerados
        g.titulo <- "Produtos madeireiros acabados"   # Primeiro titulo do grafico
        
        # Cores do Grafico: Tons vermelhos 
        cor_segmento <- "firebrick3"                    # cor da linha   
        cor_ponto <- "firebrick4"                   # cor do ponto
        
    } 
    
    if ( grupo == "geral") {
        
       lista_especies <- "Geral" # nome do arquivo gerado
        
        # Legendas do grafico
        g.sub.titulo.grupo <- "Grupos de espcies"
        
    } else if (grupo == "grupo1") {
        
        lista_especies <- unique(sisdof$Especie[sisdof$Grupo == "Grupo.1"])   # lista os nomes das espcies contidas no grupo 1
        g.sub.titulo.grupo <- "25 Espcies de maior produo madeireira"
        
    } else if (grupo == "grupo2") {
        
        lista_especies <- unique(sisdof$Especie[!is.na(sisdof$Portaria.443)])   # lista os nomes das espcies contidas no grupo 2
        g.sub.titulo.grupo <- "10 Espcies ameaadas de extino mais movimentadas"
                         
    } else if (grupo == "grupo3") {
        
        lista_especies <- unique(sisdof$Especie[!is.na(sisdof$Cites)])    # lista os nomes das espcies contidas no grupo 3
        g.sub.titulo.grupo <- "10 Espcies CITES mais movimentadas"
                         
        
    }
    
    y <- sisdof
    
    ## Faz os grupos: Todas as especies, ameacadas e CITES.
    
    y <- y[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
           by = .(Especie,
                  Portaria.443,
                  Cites)]
    
    # Renomeia as colunas V1 e V2  
    y <- dplyr::rename(y,
                       "Volume.Total" = "V1",
                       "Preco.Total" = "V2")
    
    nomes.443 <- unique(y$Especie[!is.na(y$Portaria.443)])
    
    nomes.cites <- unique(y$Especie[!is.na(y$Cites)])
    
    ## Cria o subset geral
    geral <- y
    
    # Cria a coluna Categoria para agrupar os graficos
    geral$Categoria <- "Todas as espcies"
    
    # Agrega
    geral <- geral[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                   by = .(Categoria)]
    
    # Renomeia as colunas V1 e V2  
    geral <- dplyr::rename(geral,
                           "Volume.Total" = "V1",
                           "Preco.Total" = "V2")
    
    ## Cria o subset 25 mais movimentadas
    geral.25 <- sisdof[sisdof$Grupo == "Grupo.1"]
    
    geral.25$Categoria <- "25 Espcies de maior produo madeireira"
    
    geral.25 <- geral.25[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                   by = .(Categoria)]
    
    # Renomeia as colunas V1 e V2  
    geral.25 <- dplyr::rename(geral.25,
                           "Volume.Total" = "V1",
                           "Preco.Total" = "V2")
    
    ## Cria o subset Espcies ameaadas de extino
    agregado443 <- y[!is.na(y$Portaria.443)]
    
    # Cria a coluna Categoria
    agregado443$Categoria <- "Espcies ameaadas de extino"
    
    # Agrega
    agregado443 <- agregado443[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                               by = .(Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregado443 <- dplyr::rename(agregado443,
                                 "Volume.Total" = "V1",
                                 "Preco.Total" = "V2")
    
    ## Cria o subset Cites
    agregadocites <- y[!is.na(y$Cites)]
    
    # Cria a coluna Categoria
    agregadocites$Categoria <- "Espcies CITES"
    
    # Agrega
    agregadocites <- agregadocites[, .(sum(Volume.Total), sum(Preco.Total, na.rm = TRUE)),
                                   by = .(Categoria)]
    
    # Renomeia as colunas V1 e V2  
    agregadocites <- dplyr::rename(agregadocites,
                                   "Volume.Total" = "V1",
                                   "Preco.Total" = "V2")
    
    ## Faz o grfico dos grupos
    
    if (grupo == "geral") {
        
        agregado <- rbind(geral, geral.25, agregado443, agregadocites)
        
        agregado$Categoria <- factor(agregado$Categoria, 
                                    levels = c("Todas as espcies",
                                               "25 Espcies de maior produo madeireira",
                                               "Espcies ameaadas de extino",
                                               "Espcies CITES"))
    
    
    # Para o grafico entender que  pra ordenar pelo Volume.Total
    #agregado$Categoria <- factor(agregado$Categoria, 
    #                                          levels = unique(agregado$Categoria)[order(agregado$Volume.Total, 
    #                                                                                                 decreasing = TRUE)])
    
    # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
    agregado <- mutate(agregado,  Categoria = fct_reorder(agregado$Categoria,
                                                             agregado$Volume.Total))
    
    # Ordena de forma crescente em relao ao Volume.Total
    agregado <- agregado[order(agregado$Volume.Total, decreasing = TRUE),]
    
    # Cria tabela com informaes gerais
    dados.geral <- data.table("Especie" = as.character(unique(agregado$Categoria)),
                        "Vol.Perc" = round(100*agregado$Volume.Total/agregado$Volume.Total[agregado$Categoria == "Todas as espcies"],2))
    
    # Grava a planilha com os dados
    write.csv(dados.geral, paste0("#", titulo.grupo, "_Volume Acumulado.csv"))
    
    #if (grupo == "geral") {
        
    # Altura do grafico. Varia conforme o numero de espcies
    altura <- 1 + (0.6*length(agregado$Categoria))
    
    if ((min(agregado$Volume.Total) >= 1000) & (direcao == "origem"))  {
        
        agregado$Volume.Total <- agregado$Volume.Total/1000
        g.sub.titulo <- "Produo madeireira acumulada de 2012 a 2017 (x 1.000 m^3)"
        
        } else if ((min(agregado$Volume.Total) <= 1000) & (direcao == "origem")) {
            
            g.sub.titulo <- "Produo madeireira acumulada de 2012 a 2017 (m^3)"
            
            } else if ((min(agregado$Volume.Total) >= 1000) & (direcao == "destino")) {
                
                agregado$Volume.Total <- agregado$Volume.Total/1000
                g.sub.titulo <- "Consumo de madeiras acumulado de 2012 a 2017 (x 1.000 m^3)"
                
                } else if ((min(agregado$Volume.Total) <= 1000) & (direcao == "destino")) {
                    
                    g.sub.titulo <- "Consumo de madeiras acumulado de 2012 a 2017 (m^3)"
                    
                    }
        
        # Largura do grafico. Varia de acordo com o tamanho do titulo ou subtitulo. Como a fonte do titulo e 10% maior do que a do subtitulo, multiplicamos por 1.11.
        
        largura <- data.table(tipo = c("g.titulo", "g.sub.titulo", "especie"),
                              valor = c(nchar(g.titulo),
                                        nchar(g.sub.titulo),
                                        4*max(nchar(as.character(agregado$Categoria)), na.rm = TRUE)))
        
        largura <- max(largura$valor, na.rm = TRUE)
        largura <- 0.7*largura
    
    
    gplot <- ggplot(agregado, aes(agregado$Categoria,
                                  agregado$Volume.Total,
                                  fill = Categoria)) +
        geom_bar(width=0.8, 
                     position = position_dodge(width = 0.1),
                     stat = "identity") +
        scale_y_continuous(limits=c(0, 1.3*max(agregado$Volume.Total)), oob=rescale_none)+
        geom_text(aes(label = format(round(Volume.Total, 2),     # texto do Volume.Total
                                         big.mark = ".", 
                                         decimal.mark = ",")),
                      color = cor_ponto, 
                      size = 0.35*texto,
                      hjust = 0,
                      fontface = "bold")+
        theme(plot.title = element_text(vjust=1),
                  axis.title.y = element_blank(),
                  axis.text.y = element_text(size = 1.1*texto,
                                             color = cor_ponto,
                                             face = "bold",
                                             hjust = 0),
                  axis.title.x = element_blank(),
                  axis.text.x = element_blank(),
                  axis.ticks.x = element_blank(),
                  axis.ticks.y = element_blank(),
                  panel.background = element_blank(),
                  panel.grid.major = element_blank(), 
                  panel.grid.minor = element_blank(),
                  legend.position = "none")+
        coord_flip()
        if (direcao == "origem") {
            
            gplot <- gplot + scale_fill_brewer(palette = "Blues")
        
            } else {
            
                gplot <- gplot + scale_fill_brewer(palette = "Reds")
                
            }
    
    
        
    # Abre para gravacao em PDF
    pdf(paste0("#", titulo.grupo, "_","Volume_Acumulado.pdf"), 
            width = largura/7, 
            height = altura)
    
    grid.arrange(
            gplot,
            nrow = 1,
            top = textGrob(paste0(g.sub.titulo,
                                  "\n",
                                  g.sub.titulo.grupo),
                           gp = gpar(fontface = 2, 
                                     fontsize = 26,
                                     lineheight = 0.8)))
        
        # Fecha o PDF
        dev.off()
    
    } 
    
    if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        if (grupo == "grupo1") {
            
            agregado <- y[y$Especie %in% lista_especies]
        
        }   else if (grupo == "grupo2") {
            
            agregado <- y[y$Especie %in% nomes.443]
            
            # Ordena de forma crescente em relao ao Volume.Total
            agregado <- agregado[order(agregado$Volume.Total, decreasing = TRUE),]
            
            agregado <- agregado[1:10,]
        
        } else if (grupo == "grupo3") {
            
            agregado <- y[y$Especie %in% nomes.cites]
            
            # Ordena de forma crescente em relao ao Volume.Total
            agregado <- agregado[order(agregado$Volume.Total, decreasing = TRUE),]
            
            agregado <- agregado[1:10,]
        
        }
     
    # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
    agregado <- mutate(agregado,  Especie = fct_reorder(factor(agregado$Especie),
                                                       agregado$Volume.Total))
    
    # Ordena de forma crescente em relao ao Volume.Total
    agregado <- agregado[order(agregado$Volume.Total, decreasing = TRUE),]
    
    # Cria tabela com informaes gerais
    dados.especies <- data.table("Especie" = as.character(unique(agregado$Especie)),
                              "Vol.Perc" = round(100*agregado$Volume.Total/sum(agregado$Volume.Total),2))
    
    # Grava a planilha com os dados
    write.csv(dados.especies, paste0("#", titulo.grupo, "_Volume Acumulado.csv"))
    
    # Altura do grafico. Varia conforme o numero de espcies
    altura <- 1 + (0.4*length(agregado$Especie))
    
    if ((min(agregado$Volume.Total) >= 1000) & (direcao == "origem"))  {
        
        agregado$Volume.Total <- agregado$Volume.Total/1000
        g.sub.titulo <- "Produo madeireira acumulada de 2012 a 2017 (x 1.000 m^3)"
        
    } else if ((min(agregado$Volume.Total) <= 1000) & (direcao == "origem")) {
        
        g.sub.titulo <- "Produo madeireira acumulada de 2012 a 2017 (m^3)"
        
    } else if ((min(agregado$Volume.Total) >= 1000) & (direcao == "destino")) {
        
        agregado$Volume.Total <- agregado$Volume.Total/1000
        g.sub.titulo <- "Consumo de madeiras acumulado de 2012 a 2017 (x 1.000 m^3)"
        
    } else if ((min(agregado$Volume.Total) <= 1000) & (direcao == "destino")) {
        
        g.sub.titulo <- "Consumo de madeiras acumulado de 2012 a 2017 (m^3)"
        
    }
        
        # Largura do grafico. Varia de acordo com o tamanho do titulo ou subtitulo. Como a fonte do titulo e 10% maior do que a do subtitulo, multiplicamos por 1.11.
        
        largura <- data.table(tipo = c("g.titulo", "g.sub.titulo", "especie"),
                              valor = c(nchar(g.titulo),
                                        nchar(g.sub.titulo),
                                        4*max(nchar(lista_especies), na.rm = TRUE)))
        
        largura <- max(largura$valor, na.rm = TRUE)
        
        largura <- 0.85*largura
        
        
        gplot <- ggplot(agregado, aes(agregado$Especie,
                                  agregado$Volume.Total)) +
        
        geom_bar(width=0.8, 
                 position = position_dodge(width = 0.1),
                 stat = "identity",
                 fill = cor_segmento) +
        scale_y_continuous(limits=c(0, 1.2*max(agregado$Volume.Total)), oob=rescale_none)+
        geom_text(aes(label = format(round(Volume.Total, 2),     # texto do Volume.Total
                                         big.mark = ".", 
                                         decimal.mark = ",")),
                    color = cor_ponto, 
                    size = 0.35*texto,
                    stat = "identity",
                    hjust = 0,
                    fontface = "bold")+
        theme(plot.title = element_text(vjust=1),
                  axis.title.y = element_blank(),
                axis.text.y = element_text(size = 1.1*texto,
                                             color = cor_ponto,
                                             face = "bold",
                                             hjust = 0),
                axis.title.x = element_blank(),
                axis.text.x = element_blank(),
                axis.ticks.x = element_blank(),
                axis.ticks.y = element_blank(),
                panel.background = element_blank(),
                panel.grid.major = element_blank(), 
                panel.grid.minor = element_blank())+
        coord_flip()
        
    # Abre para gravacao em PDF
    pdf(paste0(titulo.grupo, "_", "Especies_Volume_Acumulado.pdf"), 
        width = largura/7, 
        height = altura)
    
    grid.arrange(
        gplot,
        nrow = 1,
        top = textGrob(paste0(g.sub.titulo,
                              "\n",
                              g.sub.titulo.grupo),
                       gp = gpar(fontface = 2, 
                                 fontsize = 26,
                                 lineheight = 0.8)))
        
# Fecha o PDF
    dev.off()
    
    
    }
    
    setwd("..")
    setwd("..")
    setwd("..")
    
    }

vol_acumulado("origem", "geral")
vol_acumulado("origem", "grupo1")
vol_acumulado("origem", "grupo2")
vol_acumulado("origem", "grupo3")

vol_acumulado("destino", "geral")
vol_acumulado("destino", "grupo1")
vol_acumulado("destino", "grupo2")
vol_acumulado("destino", "grupo3")
    
   
    
    